/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemCrafterJobDataStore;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJobCrafter<AI extends AbstractEntityAIBasic<J, ? extends AbstractBuilding>, J extends AbstractJobCrafter<AI, J>>
extends AbstractJob<AI, J> {
    private IToken<?> rsDataStoreToken;
    private int maxCraftingCount = 0;
    private int craftCounter = 0;
    private int progress = 0;

    public AbstractJobCrafter(ICitizenData entity) {
        super(entity);
        if (entity != null) {
            this.setupRsDataStore();
        }
    }

    private void setupRsDataStore() {
        this.rsDataStoreToken = this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE).getId();
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.CRAFTER_ID;
    }

    @Override
    public void serializeToView(FriendlyByteBuf buffer) {
        super.serializeToView(buffer);
        StandardFactoryController.getInstance().serialize(buffer, this.rsDataStoreToken);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_("DataStoreToken", (Tag)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("maxCounter", this.maxCraftingCount);
        compound.m_128405_("craftCounter", this.craftCounter);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128431_().contains("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.m_128469_("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
        if (compound.m_128431_().contains("progress")) {
            this.progress = compound.m_128451_("progress");
        }
        if (compound.m_128431_().contains("maxCounter")) {
            this.progress = compound.m_128451_("maxCounter");
        }
        if (compound.m_128431_().contains("craftCounter")) {
            this.progress = compound.m_128451_("craftCounter");
        }
    }

    private IRequestSystemCrafterJobDataStore getDataStore() {
        return this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_CRAFTER_JOB_DATA_STORE);
    }

    private LinkedList<IToken<?>> getTaskQueueFromDataStore() {
        return this.getDataStore().getQueue();
    }

    public List<IToken<?>> getAssignedTasksFromDataStore() {
        return this.getDataStore().getAssignedTasks();
    }

    public boolean hasTask() {
        return !this.getTaskQueueFromDataStore().isEmpty();
    }

    public <R extends PublicCrafting> IRequest<R> getCurrentTask() {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return null;
        }
        IRequest<?> request = this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
        while (request == null) {
            this.getTaskQueueFromDataStore().remove(this.getTaskQueueFromDataStore().peekFirst());
            request = this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
        }
        return request;
    }

    public void addRequest(@NotNull IToken<?> token) {
        this.getTaskQueueFromDataStore().add(token);
    }

    public void finishRequest(boolean successful) {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return;
        }
        IToken<?> current = this.getTaskQueueFromDataStore().getFirst();
        this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.RESOLVED : RequestState.FAILED);
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.getTaskQueueFromDataStore().contains(token)) {
            this.getTaskQueueFromDataStore().remove(token);
        } else if (this.getAssignedTasksFromDataStore().contains(token)) {
            this.getAssignedTasksFromDataStore().remove(token);
        }
    }

    public void onTaskBeingScheduled(@NotNull IToken<?> token) {
        this.getAssignedTasksFromDataStore().add(token);
    }

    public void onTaskBeingResolved(@NotNull IToken<?> token) {
        this.onTaskDeletion(token);
        this.addRequest(token);
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.getTaskQueueFromDataStore());
    }

    public List<IToken<?>> getAssignedTasks() {
        return ImmutableList.copyOf(this.getAssignedTasksFromDataStore());
    }

    public int getMaxCraftingCount() {
        return this.maxCraftingCount;
    }

    public void setMaxCraftingCount(int maxCraftingCount) {
        this.maxCraftingCount = maxCraftingCount;
    }

    public int getCraftCounter() {
        return this.craftCounter;
    }

    public void setCraftCounter(int craftCounter) {
        this.craftCounter = craftCounter;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void onRemoval() {
        this.cancelAssignedRequests();
        this.getColony().getRequestManager().getDataStoreManager().remove(this.rsDataStoreToken);
    }

    private void cancelAssignedRequests() {
        for (IToken<?> t : this.getTaskQueue()) {
            this.getColony().getRequestManager().updateRequestState(t, RequestState.FAILED);
        }
    }

    public void playSound(BlockPos blockPos, EntityCitizen worker) {
    }
}

